<?php
// index.php (UI v2 — aligné sur l'outil chantier)
require_once __DIR__ . '/config.php';

// Connexion DB (PDO direct)
try {
    $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4";
    $pdo = new PDO($dsn, DB_USER, DB_PASS, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    ]);
} catch (Throwable $e) {
    die("Erreur connexion DB: " . htmlspecialchars($e->getMessage()));
}

// Items
$items = $pdo->query("SELECT id, sku, name, unit FROM items ORDER BY name")->fetchAll();

// Logo (chemin fourni)
$logoUrl = "../signature/Logo-norea.jpeg"; // depuis /www/commande/ -> /www/signature/
?>
<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>NOREA équipe — Commande</title>
  <link rel="stylesheet" href="commande_ui.css">
</head>
<body>

<header class="topbar">
  <div class="topbar-left">
    <img class="brand-logo" src="<?php echo htmlspecialchars($logoUrl); ?>" alt="NOREA">
    <div class="brand-title">NOREA <span>équipe</span></div>
  </div>

  <nav class="topbar-nav">
    <a class="pill" href="../espace-equipe/chantiers.php">Chantiers</a>
    <a class="pill" href="../espace-equipe/upload.php">Upload</a>
    <a class="pill" href="../espace-equipe/photos.php">Photos</a>
    <a class="pill" href="../espace-equipe/heures.php">Heures</a>
    <a class="pill" href="../espace-equipe/planning.php">Planning</a>
    <a class="pill" href="../espace-equipe/admin.php">Admin</a>
    <a class="pill pill-active" href="index.php">Commande</a>
  </nav>

  <div class="topbar-right">
    <div class="user">Julien</div>
    <a class="logout" href="../espace-equipe/logout.php">Déconnexion</a>
  </div>
</header>

<main class="page">
  <section class="card">
    <div class="card-head">
      <div>
        <h1>Commande</h1>
        <div class="sub">Recherche un article, ajuste les quantités, puis prévisualise le bon.</div>
      </div>
      <div class="tools">
        <input id="search" class="input" type="search" placeholder="Rechercher (réf, nom, unité)..." autocomplete="off">
        <button id="reset" type="button" class="btn btn-ghost">Reset</button>
      </div>
    </div>

    <form method="post" action="submit_order.php" id="orderForm">
      <div class="table-wrap">
        <table class="table" id="itemsTable">
          <thead>
            <tr>
              <th class="col-ref">Réf</th>
              <th>Article</th>
              <th class="col-unit">Unité</th>
              <th class="col-qty">Qté</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($items as $it): ?>
              <tr data-search="<?php
                $s = ($it['sku'] ?? '') . ' ' . ($it['name'] ?? '') . ' ' . ($it['unit'] ?? '');
                echo htmlspecialchars(mb_strtolower($s));
              ?>">
                <td class="mono"><?php echo htmlspecialchars($it['sku'] ?? ''); ?></td>
                <td class="name"><?php echo htmlspecialchars($it['name'] ?? ''); ?></td>
                <td class="col-unit"><?php echo htmlspecialchars($it['unit'] ?? ''); ?></td>
                <td class="col-qty">
                  <div class="qty">
                    <button class="qty-btn" type="button" data-step="-1" aria-label="Diminuer">−</button>
                    <input class="qty-input" type="number" min="0" step="1" inputmode="numeric"
                           name="qty[<?php echo (int)$it['id']; ?>]" value="0">
                    <button class="qty-btn" type="button" data-step="1" aria-label="Augmenter">+</button>
                  </div>
                </td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>

      <div class="card-foot">
        <div class="hint">Astuce : OSB, EPDM, vis, membrane, etc…</div>
        <button class="btn btn-primary" type="submit">Prévisualiser le bon</button>
      </div>
    </form>
  </section>
</main>

<script>
(function(){
  const q = (sel, root=document) => root.querySelector(sel);
  const qa = (sel, root=document) => Array.from(root.querySelectorAll(sel));

  const search = q('#search');
  const reset = q('#reset');
  const rows = qa('#itemsTable tbody tr');

  function applyFilter(){
    const term = (search.value || '').trim().toLowerCase();
    rows.forEach(tr => {
      const hay = tr.getAttribute('data-search') || '';
      tr.style.display = term === '' || hay.includes(term) ? '' : 'none';
    });
  }
  search.addEventListener('input', applyFilter);

  reset.addEventListener('click', () => {
    search.value = '';
    applyFilter();
    qa('.qty-input').forEach(i => i.value = 0);
  });

  q('#itemsTable').addEventListener('click', (e) => {
    const btn = e.target.closest('.qty-btn');
    if (!btn) return;
    const step = parseInt(btn.getAttribute('data-step'), 10) || 0;
    const wrap = btn.closest('.qty');
    const input = wrap ? wrap.querySelector('.qty-input') : null;
    if (!input) return;
    const cur = parseInt(input.value || '0', 10) || 0;
    input.value = Math.max(0, cur + step);
  });

  qa('.qty-input').forEach(i => i.addEventListener('keydown', (e) => {
    if (e.key === 'Enter') e.preventDefault();
  }));
})();
</script>

</body>
</html>
